# R Code for f2 Similarity Calculation
# January 2017
# Lori B. Pfahler (lori.pfahler@merck.com)
# 
# Programmed using the following R Version:
# R version 3.3.2 (2016-10-31) -- "Sincere Pumpkin Patch"
# Copyright (C) 2016 The R Foundation for Statistical Computing
# Platform: x86_64-w64-mingw32/x64 (64-bit)

f2 <- function(reference, test)
{
  n <- length(reference)
  diffsq <- (reference - test)^2
  sumdiffsq <- sum(diffsq)
  f2 <- 50*(log10((1+(1/n)*sumdiffsq)^-0.5*100))
  cat("Similarity Factor = ", round(f2,4), "\n")
}


# Example 1 in Text
f2(reference=c(29,53,70,84,95), test=c(34,58,75,89,99))

# Example 2 in text
f2(reference=c(25,45,67,82,90), test=c(40,60,78,90,99))  

# Test Results with Example 1 and 2
# > f2(c(29,53,70,84,95), c(34,58,75,89,99))
# Similarity Factor =  65.4046 
# > f2(reference=c(25,45,67,82,90), test=c(40,60,78,90,99))
# Similarity Factor =  46.0259 